/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.admin.property.wsrr;

import filenet.vw.api.VWException;
import filenet.vw.api.VWSession;
import filenet.vw.base.VWDebug;
import filenet.vw.base.VWWSRRRegistry;
import filenet.vw.idm.toolkit.VWIDMBaseFactory;
import filenet.vw.toolkit.admin.resources.VWResource;
import filenet.vw.toolkit.utils.dialog.VWMessageDialog;
import filenet.vw.toolkit.utils.ws.base.wsrr.VWWSRRRegistryItem;
import java.awt.Frame;
import java.util.Vector;
import javax.swing.JOptionPane;
import javax.swing.table.AbstractTableModel;

public class VWConfigWSRRRegistryListTableModel
extends AbstractTableModel {
    public static final int COLUMN_SERVER_NAME = 0;
    public static final int COLUMN_PORT_NUM = 1;
    public static final int COLUMN_PUBLISH = 2;
    public static final int COLUMN_USER_NAME = 3;
    public static final int COLUMN_PASSWORD = 4;
    protected Frame m_parentFrame = null;
    protected String m_dialogTitle = null;
    private VWSession m_session = null;
    private Vector m_rowData = null;
    private boolean m_bHasChanged = false;
    private String[] m_columnName = new String[]{VWResource.s_serverName, VWResource.s_portNumber, "", VWResource.s_userName, VWResource.s_password};

    public VWConfigWSRRRegistryListTableModel(Frame parentFrame, VWSession session, VWWSRRRegistry[] vwWSRRRegistrylist) {
        try {
            this.m_parentFrame = parentFrame;
            this.m_session = session;
            this.m_rowData = new Vector();
            if (vwWSRRRegistrylist != null) {
                for (int i = 0; i < vwWSRRRegistrylist.length; ++i) {
                    this.m_rowData.add(vwWSRRRegistrylist[i]);
                }
            }
            this.m_dialogTitle = VWIDMBaseFactory.instance().getVWString(4).toString();
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public VWWSRRRegistry[] getWSRRRegistries() {
        Object[] theList = new VWWSRRRegistry[this.m_rowData.size()];
        this.m_rowData.copyInto(theList);
        return theList;
    }

    public void addRow() {
        try {
            if (this.m_rowData == null) {
                this.m_rowData = new Vector();
            }
            VWWSRRRegistry WSRRRegistry = new VWWSRRRegistry();
            this.m_rowData.addElement(WSRRRegistry);
            int nRow = this.m_rowData.size() - 1;
            this.fireTableRowsInserted(nRow, nRow);
            this.m_bHasChanged = true;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void removeRow(int nRow) {
        try {
            if (this.m_rowData == null || nRow < 0 || nRow >= this.m_rowData.size()) {
                return;
            }
            VWWSRRRegistry rowItem = (VWWSRRRegistry)this.m_rowData.elementAt(nRow);
            if (rowItem != null) {
                this.m_rowData.removeElementAt(nRow);
                this.fireTableRowsDeleted(nRow, nRow);
                this.m_bHasChanged = true;
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public boolean validateRow(int nRow, boolean bShowSuccess) {
        try {
            if (this.m_rowData == null) {
                return true;
            }
            String msg = null;
            VWWSRRRegistry rowItem = (VWWSRRRegistry)this.m_rowData.elementAt(nRow);
            if (rowItem != null) {
                msg = this.checkDuplicateName(rowItem.getServerName(), nRow);
                if (msg != null && msg.length() > 0) {
                    VWMessageDialog.showOptionDialog(this.m_parentFrame, msg, this.m_dialogTitle, 1);
                    return false;
                }
                try {
                    VWWSRRRegistryItem vwWSRRRegItem = new VWWSRRRegistryItem(this.m_session, rowItem);
                    boolean bValidate = vwWSRRRegItem.isAuthenticated();
                    if (!bValidate) {
                        VWMessageDialog.showOptionDialog(this.m_parentFrame, VWResource.FailedToLoginToWsrrRegistry.toString(rowItem.getServerName()), this.m_dialogTitle, 3);
                        return false;
                    }
                    if (bShowSuccess) {
                        VWMessageDialog.showOptionDialog(this.m_parentFrame, VWResource.ValidationIsSuccess, this.m_dialogTitle, 2);
                    }
                    return true;
                }
                catch (VWException ex) {
                    this.showMessage(VWResource.FailedToLoginToWsrrRegistry.toString(rowItem.getServerName()), this.m_dialogTitle, 1, ex);
                    return false;
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return false;
        }
        return true;
    }

    public boolean hasChanged() {
        return this.m_bHasChanged;
    }

    public boolean verifyWSRRRegistries() {
        boolean bSuccess = true;
        try {
            if (this.m_rowData == null) {
                return true;
            }
            int rowCount = this.m_rowData.size();
            for (int i = rowCount - 1; i >= 0; --i) {
                boolean bOK;
                VWWSRRRegistry rowItem = (VWWSRRRegistry)this.m_rowData.elementAt(i);
                Object msg = null;
                if (rowItem == null || (bOK = this.validateRow(i, false))) continue;
                return false;
            }
            return bSuccess;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            bSuccess = false;
            return bSuccess;
        }
    }

    public Class getColumnClass(int nColumnIndex) {
        switch (nColumnIndex) {
            case 0: 
            case 1: 
            case 3: 
            case 4: {
                return String.class;
            }
            case 2: {
                return Boolean.class;
            }
        }
        return null;
    }

    public int getColumnCount() {
        return this.m_columnName.length;
    }

    public String getColumnName(int nColumn) {
        if (nColumn < 0 || nColumn > this.m_columnName.length) {
            return null;
        }
        return this.m_columnName[nColumn];
    }

    public int getRowCount() {
        if (this.m_rowData != null) {
            return this.m_rowData.size();
        }
        return 0;
    }

    public Object getValueAt(int nRowIndex, int nColumnIndex) {
        try {
            if (this.m_rowData == null) {
                return null;
            }
            VWWSRRRegistry oWSRRRegistry = (VWWSRRRegistry)this.m_rowData.elementAt(nRowIndex);
            if (oWSRRRegistry == null) {
                return null;
            }
            switch (nColumnIndex) {
                case 0: {
                    String serverName = oWSRRRegistry.getServerName();
                    if (serverName == null) {
                        serverName = "";
                    }
                    return serverName;
                }
                case 1: {
                    String port = oWSRRRegistry.getPort();
                    if (port == null) {
                        port = "";
                    }
                    return port;
                }
                case 2: {
                    return new Boolean(oWSRRRegistry.getPublish());
                }
                case 3: {
                    String userName = oWSRRRegistry.getUserName();
                    if (userName == null) {
                        userName = "";
                    }
                    return userName;
                }
                case 4: {
                    String password = oWSRRRegistry.getPassword();
                    if (password == null) {
                        password = "";
                    }
                    return password;
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return null;
    }

    public boolean isCellEditable(int nRow, int nColumn) {
        boolean bEditable = true;
        return bEditable;
    }

    public void setValueAt(Object aValue, int nRowIndex, int nColumnIndex) {
        try {
            if (this.m_rowData == null) {
                return;
            }
            VWWSRRRegistry oWSRRRegistry = (VWWSRRRegistry)this.m_rowData.elementAt(nRowIndex);
            if (oWSRRRegistry == null) {
                return;
            }
            switch (nColumnIndex) {
                case 0: {
                    oWSRRRegistry.setServerName((String)aValue);
                    this.m_bHasChanged = true;
                    break;
                }
                case 1: {
                    if (((String)aValue).compareTo("") != 0) {
                        int nId = Integer.parseInt((String)aValue);
                    }
                    oWSRRRegistry.setPort((String)aValue);
                    this.m_bHasChanged = true;
                    break;
                }
                case 2: {
                    Boolean bPublish = (Boolean)aValue;
                    oWSRRRegistry.setPublish(bPublish);
                    this.m_bHasChanged = true;
                    break;
                }
                case 3: {
                    oWSRRRegistry.setUserName((String)aValue);
                    this.m_bHasChanged = true;
                    break;
                }
                case 4: {
                    oWSRRRegistry.setPassword((String)aValue);
                    this.m_bHasChanged = true;
                }
            }
        }
        catch (NumberFormatException ex) {
            JOptionPane.showMessageDialog(this.m_parentFrame, VWResource.InvalidNumberFormat.toString((String)aValue, String.valueOf(nRowIndex + 1)), this.m_dialogTitle, 0);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public boolean isPublishEnabled(int rowIndex) {
        boolean bEnabled = false;
        if (rowIndex >= 0 || rowIndex < this.m_rowData.size()) {
            VWWSRRRegistry vwWSRRRegistry = (VWWSRRRegistry)this.m_rowData.elementAt(rowIndex);
            bEnabled = vwWSRRRegistry.getPublish();
        }
        return bEnabled;
    }

    public VWWSRRRegistry getVWWSRRRegistry(int rowIndex) {
        VWWSRRRegistry vwWSRRRegistry = null;
        if (rowIndex >= 0 || rowIndex < this.m_rowData.size()) {
            vwWSRRRegistry = (VWWSRRRegistry)this.m_rowData.elementAt(rowIndex);
        }
        return vwWSRRRegistry;
    }

    public void releaseResources() {
        this.m_dialogTitle = null;
        if (this.m_rowData != null) {
            this.m_rowData.removeAllElements();
            this.m_rowData = null;
        }
    }

    private String checkDuplicateName(String WSRRName, int row) {
        String msg = null;
        if (WSRRName == null || WSRRName.trim().length() < 1) {
            msg = VWResource.s_missingWSRRRegName.toString(String.valueOf(row + 1));
            return msg;
        }
        int rowCount = this.m_rowData.size();
        for (int i = 0; i < rowCount; ++i) {
            if (i == row) continue;
            VWWSRRRegistry WSRRReg = (VWWSRRRegistry)this.m_rowData.elementAt(i);
            String urName = WSRRReg.getServerName();
            if (urName == null || urName.length() < 1) {
                msg = VWResource.s_missingWSRRRegName.toString(String.valueOf(i + 1));
                break;
            }
            if (WSRRName.compareTo(urName) != 0) continue;
            msg = VWResource.s_duplicatedWSRRRegistryName.toString(WSRRName, String.valueOf(i + 1), String.valueOf(row + 1));
            break;
        }
        return msg;
    }

    private int showMessage(String msg, String title, int msgType) {
        return this.showMessage(msg, title, msgType, null);
    }

    private int showMessage(String msg, String title, int msgType, Exception ex) {
        int retStatus = 0;
        if (ex != null) {
            msg = msg == null ? new String(ex.toString()) : msg + "\n" + ex.toString();
        }
        retStatus = VWMessageDialog.showOptionDialog(this.m_parentFrame, msg, title, msgType);
        return retStatus;
    }

    private int showOptionDialog(String msg, String title, int msgType, int optionType) {
        int retStatus = VWMessageDialog.showOptionDialog(this.m_parentFrame, msg, title, msgType, optionType, null, null, 0, 0);
        return retStatus;
    }
}

